﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using SharpPcap;
using SharpPcap.LibPcap;
using System.Text.RegularExpressions;
using SharpPcap.WinPcap;
using SharpPcap.AirPcap;
using System.IO;

namespace Battle_Analyzer
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private string MoveList = @"(none),(none),(none),(none),(none),(none),(none),(none),(none)
1,Pound,Normal,Physical,Tough,35,40,100%,I
2,Karate Chop,Fighting,Physical,Tough,25,50,100%,I
3,Double Slap,Normal,Physical,Tough,10,15,85%,I
4,Comet Punch,Normal,Physical,Tough,15,18,85%,I
5,Mega Punch,Normal,Physical,Tough,20,80,85%,I
6,Pay Day,Normal,Physical,Smart,20,40,100%,I
7,Fire Punch,Fire,Physical,Beauty,15,75,100%,I
8,Ice Punch,Ice,Physical,Beauty,15,75,100%,I
9,Thunder Punch,Electric,Physical,Cool,15,75,100%,I
10,Scratch,Normal,Physical,Tough,35,40,100%,I
11,Vice Grip,Normal,Physical,Tough,30,55,100%,I
12,Guillotine,Normal,Physical,Cool,5,-----,-----,I
13,Razor Wind,Normal,Special,Cool,10,80,100%,I
14,Swords Dance,Normal,Status,Beauty,30,-----,-----,I
15,Cut,Normal,Physical,Cool,30,50,95%,I
16,Gust,Flying,Special,Smart,35,40,100%,I
17,Wing Attack,Flying,Physical,Cool,35,60,100%,I
18,Whirlwind,Normal,Status,Smart,20,-----,100%,I
19,Fly,Flying,Physical,Smart,15,90,95%,I
20,Bind,Normal,Physical,Tough,20,15,85%,I
21,Slam,Normal,Physical,Tough,20,80,75%,I
22,Vine Whip,Grass,Physical,Cool,15,35,100%,I
23,Stomp,Normal,Physical,Tough,20,65,100%,I
24,Double Kick,Fighting,Physical,Cool,30,30,100%,I
25,Mega Kick,Normal,Physical,Cool,5,120,75%,I
26,Jump Kick,Fighting,Physical,Cool,10,100,95%,I
27,Rolling Kick,Fighting,Physical,Cool,15,60,85%,I
28,Sand Attack,Ground,Status,Cute,15,-----,100%,I
29,Headbutt,Normal,Physical,Tough,15,70,100%,I
30,Horn Attack,Normal,Physical,Cool,25,65,100%,I
31,Fury Attack,Normal,Physical,Cool,20,15,85%,I
32,Horn Drill,Normal,Physical,Cool,5,-----,-----,I
33,Tackle,Normal,Physical,Tough,35,50,100%,I
34,Body Slam,Normal,Physical,Tough,15,85,100%,I
35,Wrap,Normal,Physical,Tough,20,15,90%,I
36,Take Down,Normal,Physical,Tough,20,90,85%,I
37,Thrash,Normal,Physical,Tough,10,120,100%,I
38,Double-Edge,Normal,Physical,Tough,15,120,100%,I
39,Tail Whip,Normal,Status,Cute,30,-----,100%,I
40,Poison Sting,Poison,Physical,Smart,35,15,100%,I
41,Twineedle,Bug,Physical,Cool,20,25,100%,I
42,Pin Missile,Bug,Physical,Cool,20,14,85%,I
43,Leer,Normal,Status,Cool,30,-----,100%,I
44,Bite,Dark,Physical,Tough,25,60,100%,I
45,Growl,Normal,Status,Cute,40,-----,100%,I
46,Roar,Normal,Status,Cool,20,-----,100%,I
47,Sing,Normal,Status,Cute,15,-----,55%,I
48,Supersonic,Normal,Status,Smart,20,-----,55%,I
49,Sonic Boom,Normal,Special,Cool,20,,90%,I
50,Disable,Normal,Status,Smart,20,-----,100%,I
51,Acid,Poison,Special,Smart,30,40,100%,I
52,Ember,Fire,Special,Beauty,25,40,100%,I
53,Flamethrower,Fire,Special,Beauty,15,95,100%,I
54,Mist,Ice,Status,Beauty,30,-----,-----,I
55,Water Gun,Water,Special,Cute,25,40,100%,I
56,Hydro Pump,Water,Special,Beauty,5,120,80%,I
57,Surf,Water,Special,Beauty,15,95,100%,I
58,Ice Beam,Ice,Special,Beauty,10,95,100%,I
59,Blizzard,Ice,Special,Beauty,5,120,70%,I
60,Psybeam,Psychic,Special,Beauty,20,65,100%,I
61,Bubble Beam,Water,Special,Beauty,20,65,100%,I
62,Aurora Beam,Ice,Special,Beauty,20,65,100%,I
63,Hyper Beam,Normal,Special,Cool,5,150,90%,I
64,Peck,Flying,Physical,Cool,35,35,100%,I
65,Drill Peck,Flying,Physical,Cool,20,80,100%,I
66,Submission,Fighting,Physical,Cool,25,80,80%,I
67,Low Kick,Fighting,Physical,Tough,20,-----,100%,I
68,Counter,Fighting,Physical,Tough,20,-----,100%,I
69,Seismic Toss,Fighting,Physical,Tough,20,-----,100%,I
70,Strength,Normal,Physical,Tough,15,80,100%,I
71,Absorb,Grass,Special,Smart,25,20,100%,I
72,Mega Drain,Grass,Special,Smart,15,40,100%,I
73,Leech Seed,Grass,Status,Smart,10,-----,90%,I
74,Growth,Normal,Status,Beauty,40,-----,-----,I
75,Razor Leaf,Grass,Physical,Cool,25,55,95%,I
76,Solar Beam,Grass,Special,Cool,10,120,100%,I
77,Poison Powder,Poison,Status,Smart,35,-----,75%,I
78,Stun Spore,Grass,Status,Smart,30,-----,75%,I
79,Sleep Powder,Grass,Status,Smart,15,-----,75%,I
80,Petal Dance,Grass,Special,Beauty,10,120,100%,I
81,String Shot,Bug,Status,Smart,40,-----,95%,I
82,Dragon Rage,Dragon,Special,Cool,10,,100%,I
83,Fire Spin,Fire,Special,Beauty,15,35,85%,I
84,Thunder Shock,Electric,Special,Cool,30,40,100%,I
85,Thunderbolt,Electric,Special,Cool,15,95,100%,I
86,Thunder Wave,Electric,Status,Cool,20,-----,100%,I
87,Thunder,Electric,Special,Cool,10,120,70%,I
88,Rock Throw,Rock,Physical,Tough,15,50,90%,I
89,Earthquake,Ground,Physicalspan>,Tough,10,100,100%,I
90,Fissure,Ground,Physical,Tough,5,-----,-----,I
91,Dig,Ground,Physical,Smart,10,80,100%,I
92,Toxic,Poison,Status,Smart,10,-----,90%,I
93,Confusion,Psychic,Special,Smart,25,50,100%,I
94,Psychic,Psychic,Special,Smart,10,90,100%,I
95,Hypnosis,Psychic,Status,Smart,20,-----,60%,I
96,Meditate,Psychic,Status,Beauty,40,-----,-----,I
97,Agility,Psychic,Status,Cool,30,-----,-----,I
98,Quick Attack,Normal,Physical,Cool,30,40,100%,I
99,Rage,Normal,Physical,Cool,20,20,100%,I
100,Teleport,Psychic,Status,Cool,20,-----,-----,I
101,Night Shade,Ghost,Special,Smart,15,-----,100%,I
102,Mimic,Normal,Status,Cute,10,-----,100%,I
103,Screech,Normal,Status,Smart,40,-----,85%,I
104,Double Team,Normal,Status,Cool,15,-----,-----,I
105,Recover,Normal,Status,Smart,10,-----,-----,I
106,Harden,Normal,Status,Tough,30,-----,-----,I
107,Minimize,Normal,Status,Cute,20,-----,-----,I
108,Smokescreen,Normal,Status,Smart,20,-----,100%,I
109,Confuse Ray,Ghost,Status,Smart,10,-----,100%,I
110,Withdraw,Water,Status,Cute,40,-----,-----,I
111,Defense Curl,Normal,Status,Cute,40,-----,-----,I
112,Barrier,Psychic,Status,Cool,30,-----,-----,I
113,Light Screen,Psychic,Status,Beauty,30,-----,-----,I
114,Haze,Ice,Status,Beauty,30,-----,-----,I
115,Reflect,Psychic,Status,Smart,20,-----,-----,I
116,Focus Energy,Normal,Status,Cool,30,-----,-----,I
117,Bide,Normal,Physical,Tough,10,-----,100%,I
118,Metronome,Normal,Status,Cute,10,-----,-----,I
119,Mirror Move,Flying,Status,Smart,20,-----,-----,I
120,Self-Destruct,Normal,Physical,Beauty,5,200,100%,I
121,Egg Bomb,Normal,Physical,Tough,10,100,75%,I
122,Lick,Ghost,Physical,Tough,30,20,100%,I
123,Smog,Poison,Special,Tough,20,20,70%,I
124,Sludge,Poison,Special,Tough,20,65,100%,I
125,Bone Club,Ground,Physical,Tough,20,65,85%,I
126,Fire Blast,Fire,Special,Beauty,5,120,85%,I
127,Waterfall,Water,Physical,Tough,15,80,100%,I
128,Clamp,Water,Physical,Tough,10,35,85%,I
129,Swift,Normal,Special,Cool,20,60,-----,I
130,Skull Bash,Normal,Physical,Tough,15,100,100%,I
131,Spike Cannon,Normal,Physical,Cool,15,20,100%,I
132,Constrict,Normal,Physical,Tough,35,10,100%,I
133,Amnesia,Psychic,Status,Cute,20,-----,-----,I
134,Kinesis,Psychic,Status,Smart,15,-----,80%,I
135,Soft-Boiled,Normal,Status,Beauty,10,-----,-----,I
136,High Jump Kick,Fighting,Physical,Cool,10,130,90%,I
137,Glare,Normal,Status,Tough,30,-----,90%,I
138,Dream Eater,Psychic,Special,Smart,15,100,100%,I
139,Poison Gas,Poison,Status,Smart,40,-----,80%,I
140,Barrage,Normal,Physical,Tough,20,15,85%,I
141,Leech Life,Bug,Physical,Smart,15,20,100%,I
142,Lovely Kiss,Normal,Status,Beauty,10,-----,75%,I
143,Sky Attack,Flying,Physical,Cool,5,140,90%,I
144,Transform,Normal,Status,Smart,10,-----,-----,I
145,Bubble,Water,Special,Cute,30,20,100%,I
146,Dizzy Punch,Normal,Physical,Cool,10,70,100%,I
147,Spore,Grass,Status,Beauty,15,-----,100%,I
148,Flash,Normal,Status,Beauty,20,-----,100%,I
149,Psywave,Psychic,Special,Smart,15,-----,80%,I
150,Splash,Normal,Status,Cute,40,-----,-----,I
151,Acid Armor,Poison,Status,Tough,40,-----,-----,I
152,Crabhammer,Water,Physical,Tough,10,90,90%,I
153,Explosion,Normal,Physical,Beauty,5,250,100%,I
154,Fury Swipes,Normal,Physical,Tough,15,18,80%,I
155,Bonemerang,Ground,Physical,Tough,10,50,90%,I
156,Rest,Psychic,Status,Cute,10,-----,-----,I
157,Rock Slide,Rock,Physical,Tough,10,75,90%,I
158,Hyper Fang,Normal,Physical,Cool,15,80,90%,I
159,Sharpen,Normal,Status,Cute,30,-----,-----,I
160,Conversion,Normal,Status,Beauty,30,-----,-----,I
161,Tri Attack,Normal,Special,Beauty,10,80,100%,I
162,Super Fang,Normal,Physical,Tough,10,-----,90%,I
163,Slash,Normal,Physical,Cool,20,70,100%,I
164,Substitute,Normal,Status,Smart,10,-----,-----,I
165,Struggle,Normal,Physical,Cool,1,50,100%,I
166,Sketch,Normal,Status,Smart,1,-----,-----,II
167,Triple Kick,Fighting,Physical,Cool,10,10,90%,II
168,Thief,Dark,Physical,Tough,10,40,100%,II
169,Spider Web,Bug,Status,Smart,10,-----,100%,II
170,Mind Reader,Normal,Status,Smart,5,-----,100%,II
171,Nightmare,Ghost,Status,Smart,15,-----,100%,II
172,Flame Wheel,Fire,Physical,Beauty,25,60,100%,II
173,Snore,Normal,Special,Cute,15,40,100%,II
174,Curse,Ghost,Status,Tough,10,-----,-----,II
175,Flail,Normal,Physical,Cute,15,-----,100%,II
176,Conversion 2,Normal,Status,Beauty,30,-----,100%,II
177,Aeroblast,Flying,Special,Cool,5,100,95%,II
178,Cotton Spore,Grass,Status,Beauty,40,-----,100%,II
179,Reversal,Fighting,Physical,Cool,15,-----,100%,II
180,Spite,Ghost,Status,Tough,10,-----,100%,II
181,Powder Snow,Ice,Special,Beauty,25,40,100%,II
182,Protect,Normal,Status,Cute,10,-----,-----,II
183,Mach Punch,Fighting,Physical,Cool,30,40,100%,II
184,Scary Face,Normal,Status,Tough,10,-----,100%,II
185,Feint Attack,Dark,Physical,Smart,20,60,-----,II
186,Sweet Kiss,Fairy,Status,Cute,10,-----,75%,II
187,Belly Drum,Normal,Status,Cute,10,-----,-----,II
188,Sludge Bomb,Poison,Special,Tough,10,90,100%,II
189,Mud-Slap,Ground,Special,Cute,10,20,100%,II
190,Octazooka,Water,Special,Tough,10,65,85%,II
191,Spikes,Ground,Status,Smart,20,-----,-----,II
192,Zap Cannon,Electric,Special,Cool,5,120,50%,II
193,Foresight,Normal,Status,Smart,40,-----,100%,II
194,Destiny Bond,Ghost,Status,Smart,5,-----,-----,II
195,Perish Song,Normal,Status,Beauty,5,-----,-----,II
196,Icy Wind,Ice,Special,Beauty,15,55,95%,II
197,Detect,Fighting,Status,Cool,5,-----,-----,II
198,Bone Rush,Ground,Physical,Tough,10,25,90%,II
199,Lock-On,Normal,Status,Smart,5,-----,100%,II
200,Outrage,Dragon,Physical,Cool,15,120,100%,II
201,Sandstorm,Rock,Status,Tough,10,-----,-----,II
202,Giga Drain,Grass,Special,Smart,10,75,100%,II
203,Endure,Normal,Status,Tough,10,-----,-----,II
204,Charm,Fairy,Status,Cute,20,-----,100%,II
205,Rollout,Rock,Physical,Tough,20,30,90%,II
206,False Swipe,Normal,Physical,Cool,40,40,100%,II
207,Swagger,Normal,Status,Cute,15,-----,90%,II
208,Milk Drink,Normal,Status,Cute,10,-----,-----,II
209,Spark,Electric,Physical,Cool,20,65,100%,II
210,Fury Cutter,Bug,Physical,Cool,20,20,95%,II
211,Steel Wing,Steel,Physical,Cool,25,70,90%,II
212,Mean Look,Normal,Status,Beauty,5,-----,100%,II
213,Attract,Normal,Status,Cute,15,-----,100%,II
214,Sleep Talk,Normal,Status,Cute,10,-----,-----,II
215,Heal Bell,Normal,Status,Beauty,5,-----,-----,II
216,Return,Normal,Physical,Cute,20,-----,100%,II
217,Present,Normal,Physical,Cute,15,-----,90%,II
218,Frustration,Normal,Physical,Cute,20,-----,100%,II
219,Safeguard,Normal,Status,Beauty,25,-----,-----,II
220,Pain Split,Normal,Status,Smart,20,-----,100%,II
221,Sacred Fire,Fire,Physical,Beauty,5,100,95%,II
222,Magnitude,Ground,Physical,Tough,30,-----,100%,II
223,Dynamic Punch,Fighting,Physical,Cool,5,100,50%,II
224,Megahorn,Bug,Physical,Cool,10,120,85%,II
225,Dragon Breath,Dragon,Special,Cool,20,60,100%,II
226,Baton Pass,Normal,Status,Cute,40,-----,-----,II
227,Encore,Normal,Status,Cute,5,-----,100%,II
228,Pursuit,Dark,Physical,Smart,20,40,100%,II
229,Rapid Spin,Normal,Physical,Cool,40,20,100%,II
230,Sweet Scent,Normal,Status,Cute,20,-----,100%,II
231,Iron Tail,Steel,Physical,Cool,15,100,75%,II
232,Metal Claw,Steel,Physical,Cool,35,50,95%,II
233,Vital Throw,Fighting,Physical,Cool,10,70,100%,II
234,Morning Sun,Normal,Status,Beauty,5,-----,-----,II
235,Synthesis,Grass,Status,Smart,5,-----,-----,II
236,Moonlight,Fairy,Status,Beauty,5,-----,-----,II
237,Hidden Power,Normal,Special,Smart,15,-----,100%,II
238,Cross Chop,Fighting,Physical,Cool,5,100,80%,II
239,Twister,Dragon,Special,Cool,20,40,100%,II
240,Rain Dance,Water,Status,Tough,5,-----,-----,II
241,Sunny Day,Fire,Status,Beauty,5,-----,-----,II
242,Crunch,Dark,Physical,Tough,15,80,100%,II
243,Mirror Coat,Psychic,Special,Beauty,20,-----,100%,II
244,Psych Up,Normal,Status,Smart,10,-----,-----,II
245,Extreme Speed,Normal,Physical,Cool,5,80,100%,II
246,Ancient Power,Rock,Special,Tough,5,60,100%,II
247,Shadow Ball,Ghost,Special,Smart,15,80,100%,II
248,Future Sight,Psychic,Special,Smart,10,100,100%,II
249,Rock Smash,Fighting,Physical,Tough,15,40,100%,II
250,Whirlpool,Water,Special,Beauty,15,35,85%,II
251,Beat Up,Dark,Physical,Smart,10,-----,100%,II
252,Fake Out,Normal,Physical,Cute,10,40,100%,III
253,Uproar,Normal,Special,Cute,10,90,100%,III
254,Stockpile,Normal,Status,Tough,20,-----,-----,III
255,Spit Up,Normal,Special,Tough,10,-----,100%,III
256,Swallow,Normal,Status,Tough,10,-----,-----,III
257,Heat Wave,Fire,Special,Beauty,10,100,90%,III
258,Hail,Ice,Status,Beauty,10,-----,-----,III
259,Torment,Dark,Status,Tough,15,-----,100%,III
260,Flatter,Dark,Status,Smart,15,-----,100%,III
261,Will-O-Wisp,Fire,Status,Beauty,15,-----,75%,III
262,Memento,Dark,Status,Tough,10,-----,100%,III
263,Facade,Normal,Physical,Cute,20,70,100%,III
264,Focus Punch,Fighting,Physical,Tough,20,150,100%,III
265,Smelling Salts,Normal,Physical,Smart,10,60,100%,III
266,Follow Me,Normal,Status,Cute,20,-----,100%,III
267,Nature Power,Normal,Status,Beauty,20,-----,-----,III
268,Charge,Electric,Status,Smart,20,-----,-----,III
269,Taunt,Dark,Status,Smart,20,-----,100%,III
270,Helping Hand,Normal,Status,Smart,20,-----,-----,III
271,Trick,Psychic,Status,Smart,10,-----,100%,III
272,Role Play,Psychic,Status,Cute,10,-----,-----,III
273,Wish,Normal,Status,Cute,10,-----,-----,III
274,Assist,Normal,Status,Cute,20,-----,-----,III
275,Ingrain,Grass,Status,Smart,20,-----,-----,III
276,Superpower,Fighting,Physical,Tough,5,120,100%,III
277,Magic Coat,Psychic,Status,Beauty,15,-----,-----,III
278,Recycle,Normal,Status,Smart,10,-----,100%,III
279,Revenge,Fighting,Physical,Tough,10,60,100%,III
280,Brick Break,Fighting,Physical,Cool,15,75,100%,III
281,Yawn,Normal,Status,Cute,10,-----,100%,III
282,Knock Off,Dark,Physical,Smart,20,20,100%,III
283,Endeavor,Normal,Physical,Tough,5,-----,100%,III
284,Eruption,Fire,Special,Beauty,5,-----,100%,III
285,Skill Swap,Psychic,Status,Smart,10,-----,100%,III
286,Imprison,Psychic,Status,Smart,10,-----,100%,III
287,Refresh,Normal,Status,Cute,20,-----,100%,III
288,Grudge,Ghost,Status,Tough,5,-----,100%,III
289,Snatch,Dark,Status,Smart,10,-----,100%,III
290,Secret Power,Normal,Physical,Smart,20,70,100%,III
291,Dive,Water,Physical,Beauty,10,80,100%,III
292,Arm Thrust,Fighting,Physical,Tough,20,15,100%,III
293,Camouflage,Normal,Status,Smart,20,-----,100%,III
294,Tail Glow,Bug,Status,Beauty,20,-----,100%,III
295,Luster Purge,Psychic,Special,Smart,5,70,100%,III
296,Mist Ball,Psychic,Special,Smart,5,70,100%,III
297,Feather Dance,Flying,Status,Beauty,15,-----,100%,III
298,Teeter Dance,Normal,Status,Cute,20,-----,100%,III
299,Blaze Kick,Fire,Physical,Beauty,10,85,90%,III
300,Mud Sport,Ground,Status,Cute,15,-----,100%,III
301,Ice Ball,Ice,Physical,Beauty,20,30,90%,III
302,Needle Arm,Grass,Physical,Smart,15,60,100%,III
303,Slack Off,Normal,Status,Cute,10,-----,100%,III
304,Hyper Voice,Normal,Special,Cool,10,90,100%,III
305,Poison Fang,Poison,Physical,Smart,15,50,100%,III
306,Crush Claw,Normal,Physical,Cool,10,75,95%,III
307,Blast Burn,Fire,Special,Beauty,5,150,90%,III
308,Hydro Cannon,Water,Special,Beauty,5,150,90%,III
309,Meteor Mash,Steel,Physical,Cool,10,100,85%,III
310,Astonish,Ghost,Physical,Smart,15,30,100%,III
311,Weather Ball,Normal,Special,Smart,10,50,100%,III
312,Aromatherapy,Grass,Status,Smart,5,-----,-----,III
313,Fake Tears,Dark,Status,Smart,20,-----,100%,III
314,Air Cutter,Flying,Special,Cool,25,55,95%,III
315,Overheat,Fire,Special,Beauty,5,140,90%,III
316,Odor Sleuth,Normal,Status,Smart,40,-----,100%,III
317,Rock Tomb,Rock,Physical,Smart,10,50,80%,III
318,Silver Wind,Bug,Special,Beauty,5,60,100%,III
319,Metal Sound,Steel,Status,Smart,40,-----,85%,III
320,Grass Whistle,Grass,Status,Smart,15,-----,55%,III
321,Tickle,Normal,Status,Cute,20,-----,100%,III
322,Cosmic Power,Psychic,Status,Cool,20,-----,-----,III
323,Water Spout,Water,Special,Beauty,5,-----,100%,III
324,Signal Beam,Bug,Special,Beauty,15,75,100%,III
325,Shadow Punch,Ghost,Physical,Smart,20,60,-----,III
326,Extrasensory,Psychic,Special,Cool,30,80,100%,III
327,Sky Uppercut,Fighting,Physical,Cool,15,85,90%,III
328,Sand Tomb,Ground,Physical,Smart,15,35,85%,III
329,Sheer Cold,Ice,Special,Beauty,5,-----,-----,III
330,Muddy Water,Water,Special,Tough,10,95,85%,III
331,Bullet Seed,Grass,Physical,Cool,30,25,100%,III
332,Aerial Ace,Flying,Physical,Cool,20,60,-----,III
333,Icicle Spear,Ice,Physical,Beauty,30,25,100%,III
334,Iron Defense,Steel,Status,Tough,15,-----,-----,III
335,Block,Normal,Status,Cute,5,-----,100%,III
336,Howl,Normal,Status,Cool,40,-----,-----,III
337,Dragon Claw,Dragon,Physical,Cool,15,80,100%,III
338,Frenzy Plant,Grass,Special,Cool,5,150,90%,III
339,Bulk Up,Fighting,Status,Beauty,20,-----,-----,III
340,Bounce,Flying,Physical,Cute,5,85,85%,III
341,Mud Shot,Ground,Special,Tough,15,55,95%,III
342,Poison Tail,Poison,Physical,Smart,25,50,100%,III
343,Covet,Normal,Physical,Cute,40,60,100%,III
344,Volt Tackle,Electric,Physical,Cool,15,120,100%,III
345,Magical Leaf,Grass,Special,Beauty,20,60,-----,III
346,Water Sport,Water,Status,Cute,15,-----,100%,III
347,Calm Mind,Psychic,Status,Smart,20,-----,-----,III
348,Leaf Blade,Grass,Physical,Cool,15,90,100%,III
349,Dragon Dance,Dragon,Status,Cool,20,-----,-----,III
350,Rock Blast,Rock,Physical,Tough,10,25,90%,III
351,Shock Wave,Electric,Special,Cool,20,60,-----,III
352,Water Pulse,Water,Special,Beauty,20,60,100%,III
353,Doom Desire,Steel,Special,Cool,5,140,100%,III
354,Psycho Boost,Psychic,Special,Smart,5,140,90%,III
355,Roost,Flying,Status,Cool,10,-----,-----,IV
356,Gravity,Psychic,Status,Beauty,5,-----,-----,IV
357,Miracle Eye,Psychic,Status,Cute,40,-----,-----,IV
358,Wake-Up Slap,Fighting,Physical,Smart,10,60,100%,IV
359,Hammer Arm,Fighting,Physical,Cool,10,100,90%,IV
360,Gyro Ball,Steel,Physical,Beauty,5,-----,100%,IV
361,Healing Wish,Psychic,Status,Cute,10,-----,-----,IV
362,Brine,Water,Special,Smart,10,65,100%,IV
363,Natural Gift,Normal,Physical,Cool,15,-----,100%,IV
364,Feint,Normal,Physical,Beauty,10,30,100%,IV
365,Pluck,Flying,Physical,Cute,20,60,100%,IV
366,Tailwind,Flying,Status,Smart,30,-----,-----,IV
367,Acupressure,Normal,Status,Cool,30,-----,-----,IV
368,Metal Burst,Steel,Physical,Beauty,10,-----,100%,IV
369,U-turn,Bug,Physical,Cute,20,70,100%,IV
370,Close Combat,Fighting,Physical,Smart,5,120,100%,IV
371,Payback,Dark,Physical,Cool,10,50,100%,IV
372,Assurance,Dark,Physical,Beauty,10,50,100%,IV
373,Embargo,Dark,Status,Cute,15,-----,100%,IV
374,Fling,Dark,Physical,Tough,10,-----,100%,IV
375,Psycho Shift,Psychic,Status,Cool,10,-----,90%,IV
376,Trump Card,Normal,Special,Cool,5,-----,-----,IV
377,Heal Block,Psychic,Status,Cute,15,-----,100%,IV
378,Wring Out,Normal,Special,Smart,5,-----,100%,IV
379,Power Trick,Psychic,Status,Cool,10,-----,-----,IV
380,Gastro Acid,Poison,Status,Beauty,10,-----,100%,IV
381,Lucky Chant,Normal,Status,Cute,30,-----,-----,IV
382,Me First,Normal,Status,Cute,20,-----,-----,IV
383,Copycat,Normal,Status,Cool,20,-----,-----,IV
384,Power Swap,Psychic,Status,Beauty,10,-----,-----,IV
385,Guard Swap,Psychic,Status,Cute,10,-----,-----,IV
386,Punishment,Dark,Physical,Smart,5,-----,100%,IV
387,Last Resort,Normal,Physical,Cute,5,140,100%,IV
388,Worry Seed,Grass,Status,Beauty,10,-----,100%,IV
389,Sucker Punch,Dark,Physical,Smart,5,80,100%,IV
390,Toxic Spikes,Poison,Status,Smart,20,-----,-----,IV
391,Heart Swap,Psychic,Status,Cool,10,-----,-----,IV
392,Aqua Ring,Water,Status,Beauty,20,-----,-----,IV
393,Magnet Rise,Electric,Status,Cute,10,-----,-----,IV
394,Flare Blitz,Fire,Physical,Smart,15,120,100%,IV
395,Force Palm,Fighting,Physical,Cool,10,60,100%,IV
396,Aura Sphere,Fighting,Special,Beauty,20,90,-----,IV
397,Rock Polish,Rock,Status,Tough,20,-----,-----,IV
398,Poison Jab,Poison,Physical,Smart,20,80,100%,IV
399,Dark Pulse,Dark,Special,Cool,15,80,100%,IV
400,Night Slash,Dark,Physical,Beauty,15,70,100%,IV
401,Aqua Tail,Water,Physical,Cute,10,90,90%,IV
402,Seed Bomb,Grass,Physical,Smart,15,80,100%,IV
403,Air Slash,Flying,Special,Cool,20,75,95%,IV
404,X-Scissor,Bug,Physical,Beauty,15,80,100%,IV
405,Bug Buzz,Bug,Special,Cute,10,90,100%,IV
406,Dragon Pulse,Dragon,Special,Smart,10,90,100%,IV
407,Dragon Rush,Dragon,Physical,Cool,10,100,75%,IV
408,Power Gem,Rock,Special,Beauty,20,70,100%,IV
409,Drain Punch,Fighting,Physical,Beauty,10,75,100%,IV
410,Vacuum Wave,Fighting,Special,Smart,30,40,100%,IV
411,Focus Blast,Fighting,Special,Cool,5,120,70%,IV
412,Energy Ball,Grass,Special,Beauty,10,80,100%,IV
413,Brave Bird,Flying,Physical,Cute,15,120,100%,IV
414,Earth Power,Ground,Special,Smart,10,90,100%,IV
415,Switcheroo,Dark,Status,Cool,10,-----,100%,IV
416,Giga Impact,Normal,Physical,Beauty,5,150,90%,IV
417,Nasty Plot,Dark,Status,Cute,20,-----,-----,IV
418,Bullet Punch,Steel,Physical,Smart,30,40,100%,IV
419,Avalanche,Ice,Physical,Cool,10,60,100%,IV
420,Ice Shard,Ice,Physical,Beauty,30,40,100%,IV
421,Shadow Claw,Ghost,Physical,Cute,15,70,100%,IV
422,Thunder Fang,Electric,Physical,Smart,15,65,95%,IV
423,Ice Fang,Ice,Physical,Cool,15,65,95%,IV
424,Fire Fang,Fire,Physical,Beauty,15,65,95%,IV
425,Shadow Sneak,Ghost,Physical,Smart,30,40,100%,IV
426,Mud Bomb,Ground,Special,Smart,10,65,85%,IV
427,Psycho Cut,Psychic,Physical,Cool,20,70,100%,IV
428,Zen Headbutt,Psychic,Physical,Beauty,15,80,90%,IV
429,Mirror Shot,Steel,Special,Cute,10,65,85%,IV
430,Flash Cannon,Steel,Special,Smart,10,80,100%,IV
431,Rock Climb,Normal,Physical,Cool,20,90,85%,IV
432,Defog,Flying,Status,Beauty,15,-----,-----,IV
433,Trick Room,Psychic,Status,Cute,5,-----,-----,IV
434,Draco Meteor,Dragon,Special,Smart,5,140,90%,IV
435,Discharge,Electric,Special,Cool,15,80,100%,IV
436,Lava Plume,Fire,Special,Tough,15,80,100%,IV
437,Leaf Storm,Grass,Special,Cute,5,140,90%,IV
438,Power Whip,Grass,Physical,Beauty,10,120,85%,IV
439,Rock Wrecker,Rock,Physical,Tough,5,150,90%,IV
440,Cross Poison,Poison,Physical,Cool,20,70,100%,IV
441,Gunk Shot,Poison,Physical,Cool,5,120,70%,IV
442,Iron Head,Steel,Physical,Tough,15,80,100%,IV
443,Magnet Bomb,Steel,Physical,Cool,20,60,-----,IV
444,Stone Edge,Rock,Physical,Tough,5,100,80%,IV
445,Captivate,Normal,Status,Beauty,20,-----,100%,IV
446,Stealth Rock,Rock,Status,Cool,20,-----,-----,IV
447,Grass Knot,Grass,Special,Smart,20,-----,100%,IV
448,Chatter,Flying,Special,Smart,20,60,100%,IV
449,Judgment,Normal,Special,Smart,10,100,100%,IV
450,Bug Bite,Bug,Physical,Tough,20,60,100%,IV
451,Charge Beam,Electric,Special,Beauty,10,50,90%,IV
452,Wood Hammer,Grass,Physical,Tough,15,120,100%,IV
453,Aqua Jet,Water,Physical,Beauty,20,40,100%,IV
454,Attack Order,Bug,Physical,Smart,15,90,100%,IV
455,Defend Order,Bug,Status,Smart,10,-----,-----,IV
456,Heal Order,Bug,Status,Smart,10,-----,-----,IV
457,Head Smash,Rock,Physical,Tough,5,150,80%,IV
458,Double Hit,Normal,Physical,Smart,10,35,90%,IV
459,Roar of Time,Dragon,Special,Cool,5,150,90%,IV
460,Spacial Rend,Dragon,Special,Tough,5,100,95%,IV
461,Lunar Dance,Psychic,Status,Beauty,10,-----,-----,IV
462,Crush Grip,Normal,Physical,Tough,5,-----,100%,IV
463,Magma Storm,Fire,Special,Tough,5,120,75%,IV
464,Dark Void,Dark,Status,Smart,10,-----,80%,IV
465,Seed Flare,Grass,Special,Cool,5,120,85%,IV
466,Ominous Wind,Ghost,Special,Smart,5,60,100%,IV
467,Shadow Force,Ghost,Physical,Smart,5,120,100%,IV
468,Hone Claws,Dark,Status,???,15,-----,-----,V
469,Wide Guard,Rock,Status,???,10,-----,-----,V
470,Guard Split,Psychic,Status,???,10,-----,-----,V
471,Power Split,Psychic,Status,???,10,-----,-----,V
472,Wonder Room,Psychic,Status,???,10,-----,-----,V
473,Psyshock,Psychic,Special,???,10,80,100%,V
474,Venoshock,Poison,Special,???,10,65,100%,V
475,Autotomize,Steel,Status,???,15,-----,-----,V
476,Rage Powder,Bug,Status,???,20,-----,-----,V
477,Telekinesis,Psychic,Status,???,15,-----,-----,V
478,Magic Room,Psychic,Status,???,10,-----,-----,V
479,Smack Down,Rock,Physical,???,15,50,100%,V
480,Storm Throw,Fighting,Physical,???,10,40,100%,V
481,Flame Burst,Fire,Special,???,15,70,100%,V
482,Sludge Wave,Poison,Special,???,10,95,100%,V
483,Quiver Dance,Bug,Status,???,20,-----,-----,V
484,Heavy Slam,Steel,Physical,???,10,-----,100%,V
485,Synchronoise,Psychic,Special,???,15,70,100%,V
486,Electro Ball,Electric,Special,???,10,-----,100%,V
487,Soak,Water,Status,???,20,-----,100%,V
488,Flame Charge,Fire,Physical,???,20,50,100%,V
489,Coil,Poison,Status,???,20,-----,-----,V
490,Low Sweep,Fighting,Physical,???,20,60,100%,V
491,Acid Spray,Poison,Special,???,20,40,100%,V
492,Foul Play,Dark,Physical,???,15,95,100%,V
493,Simple Beam,Normal,Status,???,15,-----,100%,V
494,Entrainment,Normal,Status,???,15,-----,100%,V
495,After You,Normal,Status,???,15,-----,-----,V
496,Round,Normal,Special,???,15,60,100%,V
497,Echoed Voice,Normal,Special,???,15,40,100%,V
498,Chip Away,Normal,Physical,???,20,70,100%,V
499,Clear Smog,Poison,Special,???,15,50,-----,V
500,Stored Power,Psychic,Special,???,10,20,100%,V
501,Quick Guard,Fighting,Status,???,15,-----,-----,V
502,Ally Switch,Psychic,Status,???,15,-----,-----,V
503,Scald,Water,Special,???,15,80,100%,V
504,Shell Smash,Normal,Status,???,15,-----,-----,V
505,Heal Pulse,Psychic,Status,???,10,-----,-----,V
506,Hex,Ghost,Special,???,10,50,100%,V
507,Sky Drop,Flying,Physical,???,10,60,100%,V
508,Shift Gear,Steel,Status,???,10,-----,-----,V
509,Circle Throw,Fighting,Physical,???,10,60,90%,V
510,Incinerate,Fire,Special,???,15,30,100%,V
511,Quash,Dark,Status,???,15,-----,100%,V
512,Acrobatics,Flying,Physical,???,15,55,100%,V
513,Reflect Type,Normal,Status,???,15,-----,-----,V
514,Retaliate,Normal,Physical,???,5,70,100%,V
515,Final Gambit,Fighting,Special,???,5,-----,100%,V
516,Bestow,Normal,Status,???,15,-----,-----,V
517,Inferno,Fire,Special,???,5,100,50%,V
518,Water Pledge,Water,Special,???,10,50,100%,V
519,Fire Pledge,Fire,Special,???,10,50,100%,V
520,Grass Pledge,Grass,Special,???,10,50,100%,V
521,Volt Switch,Electric,Special,???,20,70,100%,V
522,Struggle Bug,Bug,Special,???,20,30,100%,V
523,Bulldoze,Ground,Physical,???,20,60,100%,V
524,Frost Breath,Ice,Special,???,10,40,90%,V
525,Dragon Tail,Dragon,Physical,???,10,60,90%,V
526,Work Up,Normal,Status,???,30,-----,-----,V
527,Electroweb,Electric,Special,???,15,55,95%,V
528,Wild Charge,Electric,Physical,???,15,90,100%,V
529,Drill Run,Ground,Physical,???,10,80,95%,V
530,Dual Chop,Dragon,Physical,???,15,40,90%,V
531,Heart Stamp,Psychic,Physical,???,25,60,100%,V
532,Horn Leech,Grass,Physical,???,10,75,100%,V
533,Sacred Sword,Fighting,Physical,???,20,90,100%,V
534,Razor Shell,Water,Physical,???,10,75,95%,V
535,Heat Crash,Fire,Physical,???,10,-----,100%,V
536,Leaf Tornado,Grass,Special,???,10,65,90%,V
537,Steamroller,Bug,Physical,???,20,65,100%,V
538,Cotton Guard,Grass,Status,???,10,-----,-----,V
539,Night Daze,Dark,Special,???,10,85,95%,V
540,Psystrike,Psychic,Special,???,10,100,100%,V
541,Tail Slap,Normal,Physical,???,10,25,85%,V
542,Hurricane,Flying,Special,???,10,120,70%,V
543,Head Charge,Normal,Physical,???,15,120,100%,V
544,Gear Grind,Steel,Physical,???,15,50,85%,V
545,Searing Shot,Fire,Special,???,5,100,100%,V
546,Techno Blast,Normal,Special,???,5,85,100%,V
547,Relic Song,Normal,Special,???,10,75,100%,V
548,Secret Sword,Fighting,Special,???,10,85,100%,V
549,Glaciate,Ice,Special,???,10,65,95%,V
550,Bolt Strike,Electric,Physical,???,5,130,85%,V
551,Blue Flare,Fire,Special,???,5,130,85%,V
552,Fiery Dance,Fire,Special,???,10,80,100%,V
553,Freeze Shock,Ice,Physical,???,5,140,90%,V
554,Ice Burn,Ice,Special,???,5,140,90%,V
555,Snarl,Dark,Special,???,15,55,95%,V
556,Icicle Crash,Ice,Physical,???,10,85,90%,V
557,V-create,Fire,Physical,???,5,180,95%,V
558,Fusion Flare,Fire,Special,???,5,100,100%,V
559,Fusion Bolt,Electric,Physical,???,5,100,100%,V
560,Flying Press,Fighting,Physical,???,10,80,95%,VI
561,Mat Block,Fighting,Status,???,10,-----,-----,VI
562,Belch,Poison,Special,???,10,120,90%,VI
563,Rototiller,Ground,Status,???,10,-----,-----,VI
564,Sticky Web,Bug,Status,???,20,-----,-----,VI
565,Fell Stinger,Bug,Physical,???,25,30,100%,VI
566,Phantom Force,Ghost,Physical,???,10,90,100%,VI
567,Trick-or-Treat,Ghost,Status,???,20,-----,100%,VI
568,Noble Roar,Normal,Status,???,30,-----,100%,VI
569,Ion Deluge,Electric,Status,???,25,-----,-----,VI
570,Parabolic Charge,Electric,Special,???,20,50,100%,VI
571,Forest's Curse,Grass,Status,???,20,-----,100%,VI
572,Petal Blizzard,Grass,Physical,???,15,90,100%,VI
573,Freeze-Dry,Ice,Special,???,20,70,100%,VI
574,Disarming Voice,Fairy,Special,???,15,40,-----,VI
575,Parting Shot,Dark,Status,???,20,-----,100%,VI
576,Topsy-Turvy,Dark,Status,???,20,-----,100%,VI
577,Draining Kiss,Fairy,Special,???,10,50,100%,VI
578,Crafty Shield,Fairy,Status,???,10,-----,-----,VI
579,Flower Shield,Fairy,Status,???,10,-----,-----,VI
580,Grassy Terrain,Grass,Status,???,10,-----,-----,VI
581,Misty Terrain,Fairy,Status,???,10,-----,-----,VI
582,Electrify,Electric,Status,???,15,-----,-----,VI
583,Play Rough,Fairy,Physical,???,10,90,90%,VI
584,Fairy Wind,Fairy,Special,???,15,40,-----,VI
585,Moonblast,Fairy,Special,???,15,95,100%,VI
586,Boomburst,Normal,Special,???,10,140,100,VI
587,Fairy Lock,Fairy,Status,???,10,-----,-----,VI
588,King's Shield,Steel,Status,???,10,-----,-----,VI
589,Play Nice,Normal,Status,???,20,-----,-----,VI
590,Confide,Normal,Status,???,20,-----,-----,VI
591,???,???,???,???,???,???,???,VI
592,???,???,???,???,???,???,???,VI
593,???,???,???,???,???,???,???,VI
594,Water Shuriken,Water,Physical,???,20,15,100%,VI
595,Mystical Fire,Fire,Special,???,10,65,100%,VI
596,Spiky Shield,Grass,Status,???,10,-----,-----,VI
597,Aromatic Mist,Fairy,Status,???,20,-----,-----,VI
598,Eerie Impulse,Electric,Status,???,15,-----,100%,VI
599,Venom Drench,Poison,Status,???,20,-----,100%,VI
600,Powder,Bug,Status,???,20,-----,100%,VI
601,Geomancy,Fairy,Status,???,10,-----,-----,VI
602,Magnetic Flux,Electric,Status,???,20,-----,-----,VI
603,???,???,???,???,???,???,???,VI
604,Electric Terrain,Electric,Status,???,10,-----,-----,VI
605,Dazzling Gleam,Fairy,Special,???,10,80,100%,VI
606,???,???,???,???,???,???,???,VI
607,???,???,???,???,???,???,???,VI
608,Baby-Doll Eyes,Fairy,Status,???,30,-----,100%,VI
609,Nuzzle,Electric,Physical,???,20,20,100%,VI
610,???,???,???,???,???,???,???,VI
611,Infestation,Bug,Special,???,20,20,100%,VI
612,Power-Up Punch,Fighting,Physical,???,20,40,100%,VI
613,Oblivion Wing,Flying,Special,???,10,80,100%,VI
614,???,???,???,???,???,???,???,VI
615,???,???,???,???,???,???,???,VI
616,Land's Wrath,Ground,Physical,???,10,90,100%,VI";

        private List<int> moveIndex = new List<int>();
        private List<String> moveNames = new List<string>();
        private List<String> moveType = new List<string>();
        private List<String> moveCategory = new List<string>();
        private List<String> movePower = new List<string>();
        private List<String> moveAccuracy = new List<string>();

        private void Form1_Load(object sender, EventArgs e)
        {
            foreach (ICaptureDevice device in CaptureDeviceList.Instance)
            {
                string description = device.Description;
                description = Regex.Replace(new Regex("'.+'").Match(description).Value, "'", string.Empty) + " - " + ((PcapDevice)device).Interface.FriendlyName;
                devicesBox.Items.Add(description);
            }
            devicesBox.SelectedIndex = 0;
            MethodInvoker method = null;
             method = (MethodInvoker)(() =>
                                        {

            string normalized = Regex.Replace(MoveList, @"\r\n|\n\r|\n|\r", "\n");

            foreach (string line in Regex.Split(normalized, "\n"))
            {
                if (line.Contains(","))
                {
                    var values = line.Split(',');
                    try
                    {
                        moveIndex.Add(Convert.ToInt32(values[0]));
                        moveNames.Add(values[1]);
                        moveType.Add(values[2]);
                        moveCategory.Add(values[3]);
                        movePower.Add(values[6]);
                        moveAccuracy.Add(values[7]);
                    }
                    catch
                    {

                    }
                }
            }
                                        });
             accBox.Invoke(method);
        }
        
        private ICaptureDevice device;
        private bool Do_Scan;
        private byte[] MACAddress;

        private void scanButton_Click(object sender, EventArgs e)
        {
            CaptureDeviceList instance = CaptureDeviceList.Instance;
            device = instance[devicesBox.SelectedIndex];
            if (Do_Scan)
            {
                Do_Scan = false;
                device.StopCapture();
                device.Close();
                scanButton.Text = "Start Scanning";
            }
            else
            {
                Do_Scan = true;
                scanButton.Text = "Stop Scanning";
                device.OnPacketArrival += new PacketArrivalEventHandler(device_OnPacketArrival);
                int num = 0x3e8;
                if (device is AirPcapDevice)
                {
                    (device as AirPcapDevice).Open(OpenFlags.DataTransferUdp, num);
                }
                else if (device is WinPcapDevice)
                {
                    (device as WinPcapDevice).Open(OpenFlags.DataTransferUdp | OpenFlags.NoCaptureLocal, num);
                }
                else
                {
                    if (!(device is LibPcapLiveDevice))
                    {
                        throw new InvalidOperationException("unknown device type of " + device.GetType().ToString());
                    }
                    (device as LibPcapLiveDevice).Open(DeviceMode.Promiscuous, num);
                }
                device.StartCapture();
                MACAddress = device.MacAddress.GetAddressBytes();
            }
        }
        private void device_OnPacketArrival(object sender, CaptureEventArgs e)
        {
            try
            {
                bool flag2 = true;
               
                 Console.WriteLine("Elligible packet found");
                if (e.Packet.Data.Length > 100)
                {
                    for (int i = 0; i < 6; i++)
                    {
                        if (e.Packet.Data[i] != MACAddress[i])
                        {
                            flag2 = false;
                            break;
                        }
                    }
                }
                    if (e.Packet.Data.Length > 100)
                    {
                        for (int j = 0; j < e.Packet.Data.Length - 0x08; j++)
                        {
                            if ((((e.Packet.Data[j] == 1) && (e.Packet.Data[j + 1] == 1)) && ((e.Packet.Data[j + 2] == 8) && (e.Packet.Data[j + 3] == 4))) && ((e.Packet.Data[j + 4] == 0) && (e.Packet.Data[j + 5] == 0) && (e.Packet.Data[j + 6] == 00) && (e.Packet.Data[j + 7] == 0xa1)))
                            {
                                Console.WriteLine("Move found");
                                string baseByte = e.Packet.Data[j + 8].ToString("X2");
                                string supplementByte = e.Packet.Data[j + 9].ToString("X2");
                                string moveByte = supplementByte + baseByte;
                                int move = Convert.ToInt32(moveByte, 16);
                                Console.WriteLine(move);
                                if (!flag2)
                                {
                                    MethodInvoker method = null;
                                    foreach (int attack in moveIndex)
                                    {
                                        if (move == attack)
                                        {
                                            Console.WriteLine("Opponent used " + moveNames[attack - 1] + "(" + move + ")");
                                            method = (MethodInvoker)(() =>
                                            {
                                                nameBox.Text = moveNames[attack - 1];
                                                typeBox.Text = moveType[attack - 1];
                                                categoryBox.Text = moveCategory[attack - 1];
                                                powerBox.Text = movePower[attack - 1];
                                                accBox.Text = moveAccuracy[attack - 1];
                                            });
                                            nameBox.Invoke(method);
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (e.Packet.Data.Length > 900)
                    {
                        Console.WriteLine("Possible team packet found");
                        //Console.WriteLine(e.Packet.Data[0x62].ToString("X2") + " " + e.Packet.Data[0x62+]);
                        if (!flag2)
                        {
                            for (int j = 0; j < e.Packet.Data.Length - 0x0A; j++)
                            {
                                if (((e.Packet.Data[j] == 0x50) && (e.Packet.Data[j + 1] == 6) && (e.Packet.Data[j + 2] == 0) && (e.Packet.Data[j + 3] == 0) && (e.Packet.Data[j + 8] == 0) && (e.Packet.Data[j + 9] == 0)))
                                {
                                    MethodInvoker invk = null;
                                    invk = (MethodInvoker)(() =>
                                    {
                                        dataGrid.Rows.Clear();
                                    });
                                    dataGrid.Invoke(invk);

                                    Console.WriteLine(Decrypt(e.Packet.Data, j, 4));
                                    Console.WriteLine(Decrypt(e.Packet.Data, j + 0x104 + 4, 0));
                                    Console.WriteLine(Decrypt(e.Packet.Data, j + 0x208 + 4, 0));
                                    Console.WriteLine(Decrypt(e.Packet.Data, j + 0x30C + 4, 0));
                                    Console.WriteLine(Decrypt(e.Packet.Data, j + 0x410 + 4, 0));
                                    Console.WriteLine(Decrypt(e.Packet.Data, j + 0x514 + 4, 0));

                                }
                                else if ((e.Packet.Data[j] == 0x98) && (e.Packet.Data[j + 1] == 7) && (e.Packet.Data[j + 2] == 0) && (e.Packet.Data[j + 3] == 0) && (e.Packet.Data[j + 8] == 0) && (e.Packet.Data[j + 9] == 0))
                                {
                                    MethodInvoker invk = null;
                                    invk = (MethodInvoker)(() =>
                                    {
                                        dataGrid.Rows.Clear();
                                    });
                                    dataGrid.Invoke(invk);
                                    Console.WriteLine(Decrypt(e.Packet.Data, j, 4));
                                    Console.WriteLine(Decrypt(e.Packet.Data, j + 0x104 + 4, 0));
                                    Console.WriteLine(Decrypt(e.Packet.Data, j + 0x208 + 4, 0));
                                    Console.WriteLine(Decrypt(e.Packet.Data, j + 0x30C + 4, 0));
                                    Console.WriteLine(Decrypt(e.Packet.Data, j + 0x410 + 4, 0));
                                    Console.WriteLine(Decrypt(e.Packet.Data, j + 0x514 + 4, 0));

                                }
                            }
                        }
                    }
                }
                
            
            catch (Exception exception)
            {
                MessageBox.Show(exception.Message + Environment.NewLine + exception.InnerException);
            }
        }
        private bool Decrypt(byte[] packetData, int index, int offset)
        {
            MemoryStream blockA = new MemoryStream(0x38);
            MemoryStream blockB = new MemoryStream(0x38);
            MemoryStream blockC = new MemoryStream(0x38);
            MemoryStream blockD = new MemoryStream(0x38);
            MemoryStream stream5 = new MemoryStream(0xe8);
            MemoryStream pKMd = new MemoryStream(0xe8);
            uint num = 0;
            uint num2 = 0;
            uint num3 = 0;
            uint num4 = 0;
            uint num5 = 0;
            stream5.Write(packetData, index + offset, 0xe8);
            stream5.Position = 0L;
            pKMd.Position = 0L;
            for (int i = 0; i < 8; i++)
            {
                pKMd.WriteByte((byte)stream5.ReadByte());
            }
            stream5.Position = 0L;
            num = (uint)((0x41c64e6d * (((stream5.ReadByte() + (stream5.ReadByte() * 0x100)) + (stream5.ReadByte() * 0x10000)) + (stream5.ReadByte() * 0x1000000))) + 0x6073);
            stream5.Position = 8L;
            for (int j = 0; j < 0x70; j++)
            {
                num3 = (uint)(stream5.ReadByte() + (stream5.ReadByte() * 0x100));
                num4 = num3 ^ (num / 0x10000);
                pKMd.WriteByte(Convert.ToByte((uint)(num4 - ((num4 / 0x100) * 0x100))));
                pKMd.WriteByte(Convert.ToByte((uint)(num4 / 0x100)));
                num = (0x41c64e6d * num) + 0x6073;
            }
            stream5.Position = 0L;
            pKMd.Position = 8L;
            num2 = ((Convert.ToUInt32(stream5.ReadByte()) + (Convert.ToUInt32(stream5.ReadByte()) * 0x100)) + (Convert.ToUInt32(stream5.ReadByte()) * 0x10000)) + (Convert.ToUInt32(stream5.ReadByte()) * 0x1000000);
            switch ((((num2 >> 13) & 0x1f) % 0x18))
            {
                case 0:
                    this.ReadBlock_A(blockA, pKMd);
                    this.ReadBlock_B(blockB, pKMd);
                    this.ReadBlock_C(blockC, pKMd);
                    this.ReadBlock_D(blockD, pKMd);
                    break;

                case 1:
                    this.ReadBlock_A(blockA, pKMd);
                    this.ReadBlock_B(blockB, pKMd);
                    this.ReadBlock_D(blockD, pKMd);
                    this.ReadBlock_C(blockC, pKMd);
                    break;

                case 2:
                    this.ReadBlock_A(blockA, pKMd);
                    this.ReadBlock_C(blockC, pKMd);
                    this.ReadBlock_B(blockB, pKMd);
                    this.ReadBlock_D(blockD, pKMd);
                    break;

                case 3:
                    this.ReadBlock_A(blockA, pKMd);
                    this.ReadBlock_C(blockC, pKMd);
                    this.ReadBlock_D(blockD, pKMd);
                    this.ReadBlock_B(blockB, pKMd);
                    break;

                case 4:
                    this.ReadBlock_A(blockA, pKMd);
                    this.ReadBlock_D(blockD, pKMd);
                    this.ReadBlock_B(blockB, pKMd);
                    this.ReadBlock_C(blockC, pKMd);
                    break;

                case 5:
                    this.ReadBlock_A(blockA, pKMd);
                    this.ReadBlock_D(blockD, pKMd);
                    this.ReadBlock_C(blockC, pKMd);
                    this.ReadBlock_B(blockB, pKMd);
                    break;

                case 6:
                    this.ReadBlock_B(blockB, pKMd);
                    this.ReadBlock_A(blockA, pKMd);
                    this.ReadBlock_C(blockC, pKMd);
                    this.ReadBlock_D(blockD, pKMd);
                    break;

                case 7:
                    this.ReadBlock_B(blockB, pKMd);
                    this.ReadBlock_A(blockA, pKMd);
                    this.ReadBlock_D(blockD, pKMd);
                    this.ReadBlock_C(blockC, pKMd);
                    break;

                case 8:
                    this.ReadBlock_B(blockB, pKMd);
                    this.ReadBlock_C(blockC, pKMd);
                    this.ReadBlock_A(blockA, pKMd);
                    this.ReadBlock_D(blockD, pKMd);
                    break;

                case 9:
                    this.ReadBlock_B(blockB, pKMd);
                    this.ReadBlock_C(blockC, pKMd);
                    this.ReadBlock_D(blockD, pKMd);
                    this.ReadBlock_A(blockA, pKMd);
                    break;

                case 10:
                    this.ReadBlock_B(blockB, pKMd);
                    this.ReadBlock_D(blockD, pKMd);
                    this.ReadBlock_A(blockA, pKMd);
                    this.ReadBlock_C(blockC, pKMd);
                    break;

                case 11:
                    this.ReadBlock_B(blockB, pKMd);
                    this.ReadBlock_D(blockD, pKMd);
                    this.ReadBlock_C(blockC, pKMd);
                    this.ReadBlock_A(blockA, pKMd);
                    break;

                case 12:
                    this.ReadBlock_C(blockC, pKMd);
                    this.ReadBlock_A(blockA, pKMd);
                    this.ReadBlock_B(blockB, pKMd);
                    this.ReadBlock_D(blockD, pKMd);
                    break;

                case 13:
                    this.ReadBlock_C(blockC, pKMd);
                    this.ReadBlock_A(blockA, pKMd);
                    this.ReadBlock_D(blockD, pKMd);
                    this.ReadBlock_B(blockB, pKMd);
                    break;

                case 14:
                    this.ReadBlock_C(blockC, pKMd);
                    this.ReadBlock_B(blockB, pKMd);
                    this.ReadBlock_A(blockA, pKMd);
                    this.ReadBlock_D(blockD, pKMd);
                    break;

                case 15:
                    this.ReadBlock_C(blockC, pKMd);
                    this.ReadBlock_B(blockB, pKMd);
                    this.ReadBlock_D(blockD, pKMd);
                    this.ReadBlock_A(blockA, pKMd);
                    break;

                case 0x10:
                    this.ReadBlock_C(blockC, pKMd);
                    this.ReadBlock_D(blockD, pKMd);
                    this.ReadBlock_A(blockA, pKMd);
                    this.ReadBlock_B(blockB, pKMd);
                    break;

                case 0x11:
                    this.ReadBlock_C(blockC, pKMd);
                    this.ReadBlock_D(blockD, pKMd);
                    this.ReadBlock_B(blockB, pKMd);
                    this.ReadBlock_A(blockA, pKMd);
                    break;

                case 0x12:
                    this.ReadBlock_D(blockD, pKMd);
                    this.ReadBlock_A(blockA, pKMd);
                    this.ReadBlock_B(blockB, pKMd);
                    this.ReadBlock_C(blockC, pKMd);
                    break;

                case 0x13:
                    this.ReadBlock_D(blockD, pKMd);
                    this.ReadBlock_A(blockA, pKMd);
                    this.ReadBlock_C(blockC, pKMd);
                    this.ReadBlock_B(blockB, pKMd);
                    break;

                case 20:
                    this.ReadBlock_D(blockD, pKMd);
                    this.ReadBlock_B(blockB, pKMd);
                    this.ReadBlock_A(blockA, pKMd);
                    this.ReadBlock_C(blockC, pKMd);
                    break;

                case 0x15:
                    this.ReadBlock_D(blockD, pKMd);
                    this.ReadBlock_B(blockB, pKMd);
                    this.ReadBlock_C(blockC, pKMd);
                    this.ReadBlock_A(blockA, pKMd);
                    break;

                case 0x16:
                    this.ReadBlock_D(blockD, pKMd);
                    this.ReadBlock_C(blockC, pKMd);
                    this.ReadBlock_A(blockA, pKMd);
                    this.ReadBlock_B(blockB, pKMd);
                    break;

                case 0x17:
                    this.ReadBlock_D(blockD, pKMd);
                    this.ReadBlock_C(blockC, pKMd);
                    this.ReadBlock_B(blockB, pKMd);
                    this.ReadBlock_A(blockA, pKMd);
                    break;
            }
            pKMd.Position = 8L;
            blockA.Position = 0L;
            for (int k = 0; k < 0x38; k++)
            {
                pKMd.WriteByte((byte)blockA.ReadByte());
            }
            blockB.Position = 0L;
            for (int m = 0; m < 0x38; m++)
            {
                pKMd.WriteByte((byte)blockB.ReadByte());
            }
            blockC.Position = 0L;
            for (int n = 0; n < 0x38; n++)
            {
                pKMd.WriteByte((byte)blockC.ReadByte());
            }
            blockD.Position = 0L;
            for (int num11 = 0; num11 < 0x38; num11++)
            {
                pKMd.WriteByte((byte)blockD.ReadByte());
            }
            pKMd.Position = 8L;
            num5 = 0;
            for (int num12 = 0; num12 < 0x70; num12++)
            {
                num5 += (uint)(pKMd.ReadByte() + (pKMd.ReadByte() * 0x100));
                num5 -= (num5 / 0x10000) * 0x10000;
            }
            pKMd.Position = 6L;

            if (num5 == (pKMd.ReadByte() + (pKMd.ReadByte() * 0x100)))
            {
                pKMd.Position = 0L;
                MethodInvoker dataInvoker = null;
                dataInvoker = (MethodInvoker)(() =>
                {
                    byte[] pkx = new byte[0xe8];
                    pKMd.Read(pkx, 0, 0xe8);
                    dataGrid.Rows.Add();
                    dataGrid.Rows[dataGrid.Rows.Count - 1].Cells[0].Value = PokemonInterp.Species(pkx) + PokemonInterp.GenderShort(pkx);
                    dataGrid.Rows[dataGrid.Rows.Count - 1].Cells[1].Value = PokemonInterp.Nature(pkx);
                    dataGrid.Rows[dataGrid.Rows.Count - 1].Cells[2].Value = PokemonInterp.Ability(pkx);
                    dataGrid.Rows[dataGrid.Rows.Count - 1].Cells[3].Value = (((((((num2 & 0x1f)).ToString() + @"\") + (((num2 >> 5) & 0x1f)).ToString() + @"\") + (((num2 >> 10) & 0x1f)).ToString() + @"\") + (((num2 >> 20) & 0x1f)).ToString() + @"\") + (((num2 >> 0x19) & 0x1f)).ToString() + @"\") + (((num2 >> 15) & 0x1f)).ToString() + " ";
                    uint[] numArray2 = PokemonInterp.EVs(pkx);
                    dataGrid.Rows[dataGrid.Rows.Count - 1].Cells[4].Value = numArray2[0] + ", " + numArray2[1] + ", " + numArray2[2] + ", " + numArray2[3] + ", " + numArray2[4] + ", " + numArray2[5];
                    dataGrid.Rows[dataGrid.Rows.Count - 1].Cells[5].Value = PokemonInterp.Move1(pkx);
                    dataGrid.Rows[dataGrid.Rows.Count - 1].Cells[6].Value = PokemonInterp.Move2(pkx);
                    dataGrid.Rows[dataGrid.Rows.Count - 1].Cells[7].Value = PokemonInterp.Move3(pkx);
                    dataGrid.Rows[dataGrid.Rows.Count - 1].Cells[8].Value = PokemonInterp.Move4(pkx);
                    
                });
                dataGrid.Invoke(dataInvoker);
                return true;
            }
            
            return false;
        }

        private void ReadBlock_A(MemoryStream BlockA, MemoryStream PKMd)
        {
            BlockA.Position = 0L;
            for (int i = 0; i < 0x38; i++)
            {
                BlockA.WriteByte((byte)PKMd.ReadByte());
            }
        }

        private void ReadBlock_B(MemoryStream BlockB, MemoryStream PKMd)
        {
            BlockB.Position = 0L;
            for (int i = 0; i < 0x38; i++)
            {
                BlockB.WriteByte((byte)PKMd.ReadByte());
            }
        }

        private void ReadBlock_C(MemoryStream BlockC, MemoryStream PKMd)
        {
            BlockC.Position = 0L;
            for (int i = 0; i < 0x38; i++)
            {
                BlockC.WriteByte((byte)PKMd.ReadByte());
            }
        }

        private void ReadBlock_D(MemoryStream BlockD, MemoryStream PKMd)
        {
            BlockD.Position = 0L;
            for (int i = 0; i < 0x38; i++)
            {
                BlockD.WriteByte((byte)PKMd.ReadByte());
            }
        }

        private void label5_Click(object sender, EventArgs e)
        {

        }
    }
}
